$('<link>')
  .appendTo($('head'))
  .attr({type : 'text/css', rel : 'stylesheet'})
  .attr('href', 'Content/Resources/Stylesheet/skin.css');

$(document).ready(function(){

   // For the logo title in French and English -------------------------   
   var afterLogo = $("meta[name='voxco-title']").attr("content");
   
   $('h1.logo').after('<p id="logo-title" class="logo-title"></p>');
   $("#logo-title").text(afterLogo);
   

   // Get the good subject for the page --------------------------------
   var subject = $("meta[name='page-subject']").attr("content");
   var newClass = document.getElementsByClassName("off-canvas")[0];

   if (subject == "cc") {
        newClass.id = "cc-subject";

   } else if (subject == "design") {
        newClass.id = "design-subject";

   } else if (subject == "telephony") {
        newClass.id = "telephony-subject";

   } else if (subject == "agent") {
	newClass.id = "agent-subject";

   } else if (subject == "acuity") {
	newClass.id = "acuity-subject";
   } 


   // If the logo is text (no image) -----------------------------------
   var logoText = $("meta[name='text-title']").attr("content");
   
   $('h1.logo').after('<p id="logo-text" class="logo-text"></p>');
   $("#logo-text").text(logoText);


   // To catch the logo object -----------------------------------------
   if (logoText != null) {
   	var logoImg = document.getElementsByClassName("logo")[0];
        logoImg.id = "logo-image";
   }
   

   // Change the text in the search bar --------------------------------
   var searchText = $("meta[name='text-search']").attr("content");
   $("#search-field").attr('placeholder',(searchText));


   // For the software version under the header ------------------------
   var software = $("meta[name='software-version']").attr("content");
   
   $('#header').after('<div id="software-version" class="software-version"></div>');
   $("#software-version").text(software); 
});